<?php

get_header();

$sidebar_configs = campress_get_lecturer_layout_configs();

campress_render_breadcrumbs();

$display_mode = campress_get_config('lecturer_archive_item_style', 'style1');
$columns = campress_get_config('lecturer_archive_columns', 3);
$bcol = round(12/$columns);
$class = 'col-md-'.$bcol.($columns > 1 && $display_mode == 'style2' ? ' col-sm-6' : '');

?>
<section id="main-container" class="main-content <?php echo apply_filters( 'campress_lecturer_content_class', 'container' ); ?> inner">
	<div class="row">
		<?php if ( isset($sidebar_configs['left']) ) : ?>
			<div class="<?php echo esc_attr($sidebar_configs['left']['class']) ;?>">
			  	<aside class="sidebar sidebar-left" itemscope="itemscope" itemtype="http://schema.org/WPSideBar">
			   		<?php if ( is_active_sidebar( $sidebar_configs['left']['sidebar'] ) ): ?>
				   		<?php dynamic_sidebar( $sidebar_configs['left']['sidebar'] ); ?>
				   	<?php endif; ?>
			  	</aside>
			</div>
		<?php endif; ?>
		<div id="main-content" class="col-xs-12 <?php echo esc_attr($sidebar_configs['main']['class']); ?>">
			<div id="primary" class="content-area">
				<div id="content" class="site-content archive-lecturer" role="main">
					<div class="row">
						<?php
							// Start the Loop.
							$count = 1; while ( have_posts() ) : the_post();
								?>
								<div class="<?php echo esc_attr($class); ?> <?php echo ($count%$columns == 1) ? ' md-clearfix':''; ?> <?php echo ($columns > 1 && $count%2 == 1 && $display_mode == 'style2') ? ' sm-clearfix' : ''; ?>">
									<?php get_template_part( 'apus-campress/content', $display_mode ); ?>
								</div>
								<?php
							// End the loop.
							$count++; endwhile;
						?>
					</div>
				</div><!-- #content -->
			</div><!-- #primary -->
		</div>	
		<?php if ( isset($sidebar_configs['right']) ) : ?>
			<div class="<?php echo esc_attr($sidebar_configs['right']['class']) ;?>">
			  	<aside class="sidebar sidebar-right" itemscope="itemscope" itemtype="http://schema.org/WPSideBar">
			   		<?php if ( is_active_sidebar( $sidebar_configs['right']['sidebar'] ) ): ?>
				   		<?php dynamic_sidebar( $sidebar_configs['right']['sidebar'] ); ?>
				   	<?php endif; ?>
			  	</aside>
			</div>
		<?php endif; ?>
	</div>	
</section>
<?php get_footer(); ?>
