<?php

	$author_id = $lecturer->ID;
	$author_info = get_the_author_meta( 'apus_edr_info', $author_id );
?>
<div class="apus-teacher-inner style1 clearfix ">
			<div class="author-avatar">
				<a href="<?php echo esc_url( get_author_posts_url( $author_id ) ); ?>">
					<?php echo get_avatar( $author_id, 200); ?>
				</a>
				<div class="socials">
					<?php if ( isset($author_info['facebook']) && $author_info['facebook'] ): ?>
						<a href="<?php echo esc_url($author_info['facebook']); ?>" class="facebook"><i class="mn-icon-1405"></i></a>
					<?php endif; ?>
					<?php if ( isset($author_info['twitter']) && $author_info['twitter']): ?>
						<a href="<?php echo esc_url($author_info['twitter']); ?>" class="twitter"><i class="mn-icon-1406"></i></a>
					<?php endif; ?>
					<?php if ( isset($author_info['google']) && $author_info['google'] ): ?>
						<a href="<?php echo esc_url($author_info['google']); ?>" class="google"><i class="mn-icon-1409"></i></a>
					<?php endif; ?>
					<?php if ( isset($author_info['linkedin']) && $author_info['linkedin'] ): ?>
						<a href="<?php echo esc_url($author_info['linkedin']); ?>" class="linkedin"><i class="mn-icon-1408"></i></a>
					<?php endif; ?>
					<?php if ( isset($author_info['instagram']) && $author_info['instagram']): ?>
						<a href="<?php echo esc_url($author_info['instagram']); ?>" class="instagram"><i class="mn-icon-1416"></i></a>
					<?php endif; ?>
					<?php if ( isset($author_info['youtube']) && $author_info['youtube']): ?>
						<a href="<?php echo esc_url($author_info['youtube']); ?>" class="youtube"><i class="mn-icon-1407"></i></a>
					<?php endif; ?>
				</div>
			</div>
			<div class="infor">
				<h3 class="name">
					<a href="<?php echo esc_url( get_author_posts_url( $author_id ) ); ?>">
						<?php echo get_the_author_meta('display_name', $author_id ); ?>
					</a>
				</h3>
				<?php if ( isset($author_info['job']) ): ?>
					<div class="job"><?php echo trim($author_info['job']); ?></div>
				<?php endif; ?>
				<div class="description">
					<?php echo trim(campress_substring(get_the_author_meta('description', $author_id ), 14, '...')); ?>
				</div>
				<a href="<?php echo esc_url( get_author_posts_url( $author_id ) ); ?>" class="btn btn-gray"><?php echo esc_html__('View Profile', 'campress'); ?></a>
			</div>
</div>