<?php

global $post;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! comments_open() ) {
	return;
}
$total_rating = campress_get_total_rating( get_the_ID() );
$comment_ratings = campress_get_detail_ratings( get_the_ID() );
$total = campress_get_total_reviews( get_the_ID() );
?>
<div id="course-review">
	<div id="reviews">
		<h3 class="title-tab"><?php esc_html_e( 'Course Reviews', 'campress' ); ?></h3>
		<div class="row">
			<div class="col-md-5 col-sm-6">
				<div class="course-rating clearfix">
					
					<div class="average-rating">
						<div class="review-title">
							<?php $total ? printf( _n( 'Based On %1$s Review', 'Based On %1$s Reviews', $total, 'campress' ), number_format_i18n( $total ) ) : esc_html_e( 'Based On 0 Review', 'campress' ); ?>
						</div>
						<div class="rating-overall">
							<div class="average-value"><?php echo ( $total_rating ) ? esc_html( round( $total_rating, 1 ) ) : 0; ?></div>
							<span><?php esc_html_e('overall', 'campress'); ?></span>
						</div>

						<div class="rating-detailed">
							<div class="detailed-rating-inner">
								<?php for ( $i = 5; $i >= 1; $i -- ) : ?>
									<div class="skill skil-course">
										<div class="key"><?php printf( esc_html__( '%s stars', 'campress' ), $i ); ?></div>
										<div class="progress">
											<div class="value-percent"><?php echo ( $total && !empty( $comment_ratings[$i]->quantity ) ) ? esc_attr(  ( $comment_ratings[$i]->quantity / $total * 100 ) . '%' ) : '0%'; ?></div>
											<div class="progress-bar progress-bar-success progress-bar-striped " style="<?php echo ( $total && !empty( $comment_ratings[$i]->quantity ) ) ? esc_attr( 'width: ' . ( $comment_ratings[$i]->quantity / $total * 100 ) . '%' ) : 'width: 0%'; ?>">
											</div>
										</div>
										<div class="value"><?php echo empty( $comment_ratings[$i]->quantity ) ? '0' : esc_html( $comment_ratings[$i]->quantity ); ?></div>
									</div>
								<?php endfor; ?>
							</div>
						</div>
					</div>
					
				</div>
			</div>
			<div class="col-md-7 col-sm-6">
				<div id="review_form_wrapper">
					<div id="review_form">
						<?php
							$commenter = wp_get_current_commenter();
							$comment_form = array(
								'title_reply'          => have_comments() ? esc_html__( 'Add a review', 'campress' ) : sprintf( esc_html__( 'Be the first to review &ldquo;%s&rdquo;', 'campress' ), get_the_title() ),
								'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'campress' ),
								'comment_notes_before' => '',
								'comment_notes_after'  => '',
								'fields'               => array(
									'author' => '<div class="row"><div class="col-md-6"><div class="comment-form-author">' . '<label for="author">' . esc_html__( 'Name', 'campress' ) . ' <span class="required">*</span></label> ' .
									            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></div></div>',
									'email'  => '<div class="col-md-6"><div class="comment-form-email"><label for="email">' . esc_html__( 'Email', 'campress' ) . ' <span class="required">*</span></label> ' .
									            '<input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></div></div></div>',
								),
								'label_submit'  => esc_html__( 'Submit', 'campress' ),
								'logged_in_as'  => '',
								'comment_field' => ''
							);

							
							$comment_form['comment_field'] = '<label for="rating">' . esc_html__( 'Your Rating', 'campress' ) .'</label><div class="comment-form-rating rating-print-wrapper">
								<ul class="review-stars">
									<li><span class="fa fa-star-o"></span></li>
									<li><span class="fa fa-star-o"></span></li>
									<li><span class="fa fa-star-o"></span></li>
									<li><span class="fa fa-star-o"></span></li>
									<li><span class="fa fa-star-o"></span></li>
								</ul>
								<ul class="review-stars filled" style="width: 100%">
									<li><span class="fa fa-star"></span></li>
									<li><span class="fa fa-star"></span></li>
									<li><span class="fa fa-star"></span></li>
									<li><span class="fa fa-star"></span></li>
									<li><span class="fa fa-star"></span></li>
								</ul>
								<input type="hidden" value="5" name="rating" id="apus_input_rating"></div>';
							

							$comment_form['comment_field'] .= '<div class="comment-form-comment"><label for="comment">' . esc_html__( 'Your Review', 'campress' ) . '</label><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea></div>';
		 					
		 					campress_comment_form($comment_form);
						?>
					</div>
				</div>
			</div>
		</div>

		<div id="comments">
			<?php
			if ( have_comments() ) : ?>
				<ol class="commentlist">
					<?php wp_list_comments( array( 'callback' => 'campress_room_comments' ) ); ?>
				</ol>
				
				<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
					echo '<nav class="apus-pagination">';
					paginate_comments_links( apply_filters( 'apus_comment_pagination_args', array(
						'prev_text' => '&larr;',
						'next_text' => '&rarr;',
						'type'      => 'list',
					) ) );
					echo '</nav>';
				endif; ?>
				
			<?php else : ?>
				<p class="apus-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'campress' ); ?></p>
			<?php endif; ?>
		</div>
			
		<div class="clear"></div>
	</div>
</div>