<?php
$post_format = get_post_format();
global $post;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="info">
        <?php if (get_the_title()) { ?>
            <h4 class="entry-title">
                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
            </h4>
        <?php } ?>
        <div class="entry-meta">
            <a href="<?php the_permalink(); ?>"><i class="mn-icon-1102"></i>  <?php the_time( 'M d, Y' ); ?> </a>
            <?php
                printf( '<span class="post-author">%1$s<a href="%2$s"><i class="mn-icon-415"></i> %3$s</a></span>',
                    _x( '', 'Used before post author name.', 'campress' ),
                    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                    get_the_author()
                );
            ?>
            <span> <i class="mn-icon-352"></i> <?php campress_post_categories($post); ?></span>       
        </div>
    </div>

    <?php if ( $post_format == 'gallery' ) {
        $gallery = campress_post_gallery( get_the_content(), array( 'size' => 'full' ) );
    ?>
        <div class="entry-thumb <?php echo  (empty($gallery) ? 'no-thumb' : ''); ?>">
            <?php echo trim($gallery); ?>
        </div>
    <?php } elseif( $post_format == 'link' ) {
            $campress_format = campress_post_format_link_helper( get_the_content(), get_the_title() );
            $campress_title = $campress_format['title'];
            $campress_link = campress_get_link_attributes( $campress_title );
            $thumb = campress_post_thumbnail('', $campress_link);
            echo trim($thumb);
        } else { ?>
    	<div class="entry-thumb <?php echo  (!has_post_thumbnail() ? 'no-thumb' : ''); ?>">
    		<?php
                $thumb = campress_post_thumbnail();
                echo trim($thumb);
            ?>
    	</div>
    <?php } ?>
	<div class="detail-content">

    	<div class="single-info info-bottom">
    		<?php
                if ( $post_format == 'gallery' ) {
                    $gallery_filter = campress_gallery_from_content( get_the_content() );
                    echo trim($gallery_filter['filtered_content']);
                } else {
            ?>
                    <div class="entry-description"><?php the_content(); ?></div><!-- /entry-content -->
            <?php } ?>
    		<?php
    		wp_link_pages( array(
    			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'campress' ) . '</span>',
    			'after'       => '</div>',
    			'link_before' => '<span>',
    			'link_after'  => '</span>',
    			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'campress' ) . ' </span>%',
    			'separator'   => '',
    		) );
    		?>
    		<div class="tag-social clearfix ">
                <div class="pull-left">
                    <?php campress_post_tags(); ?>
                </div>
    			
    			<div class="pull-right social-share">
                    
                   <?php if( campress_get_config('show_blog_social_share', true) ) {
                        get_template_part( 'page-templates/parts/sharebox' );
                    } ?>         
                </div>
    		</div>
    	</div>
    </div>
</article>